% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program TvCcomp_costfunc.m
function L = TvCcomp_costfunc(guess, data)

Nstates = data(1, 1);
NperformanceLevels = (size(data, 1) - 2)/Nstates;
beta = guess(1);
gamma = guess(2);
Nm = guess(3);
Sa = guess(4);
Aa = [1 guess(5 : (5 + Nstates - 2))];
Af = [1 guess((5+Nstates-1) : (5 + 2* Nstates -3))];
NperformanceLevels = (size(data, 1) - 2)/Nstates;
NnoiseLevels = size(data, 2) - 1;
Next = data(2, 2:(NnoiseLevels+1));
L=0;

for i = 1 : Nstates
    for j = 1 : NperformanceLevels
        d  = ...
          norminv(data((i-1)*NperformanceLevels+2+j, 1)) - ...
          norminv( 1- data((i-1)*NperformanceLevels+2+j, 1));
        Log_observedThresholds = ...
          log(data((i-1)*NperformanceLevels+2+j, ...
          2:(NnoiseLevels+1)));
        Log_predictedThresholds = 1 / (2*gamma) * (2*log(d') ...
          + log((1+Nm^2) * (Af(i)*Next).^(2*gamma) + ...
          (Aa(i)*Sa)^2) - log(1-Nm.^2*d.^2/2)) - log(beta);
        L = L+sum ((Log_observedThresholds - ...
          Log_predictedThresholds).^2);
    end
end

